#include <iostream>
#include <cmath>
#include <string>
#include <algorithm>
#include <cstring>
#include <cstdio>
#include <fstream>
#include <cassert>
#include <map>
#include <set>
#include <vector>
#include <queue>
#include <stack>
#include <functional>
#include <numeric>
#include <ctime>
#include <cstdlib>
#include <sstream>

using namespace std;

#define f first
#define s second
#define mp make_pair
#define pb push_back
#define pii pair<int, int>
#define pll pair<long long, long long>
#define y1 stupid_y1
#define ll long long
#define vi vector<int>
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(a) a.begin(), a.end()
#define sqr(x) ((x)*(x))
#define sz(a) (int)a.size()
#define file "a"

const int maxn = (int)1e5+11;
const int inf = int(1e9);
const int mod = inf + 7;
const double eps = 1e-9;
const double pi = acos(-1.0);

struct Point {
	double x, y;

	Point () {}
	Point (double x, double y) : x(x), y(y) {}

	void print() {
		printf("%.9lf %.9lf\n", x, y);
	}

	double dist(Point o) {
		return sqrt(sqr(o.x - x) + sqr(o.y - y));
	}
	
	void normalization() {
		double d = sqrt(sqr(x) + sqr(y));
		if(d < eps) return;
		x /= d;
		y /= d;
	}

	Point const operator +(Point o) {
		return Point(x + o.x, y + o.y);
	}
	Point const operator -(Point o) {
		return Point(x - o.x, y - o.y);
	}
	Point const operator *(double k) {
		return Point(x * k, y * k);
	}
	Point const operator /(double k) {
		return Point(x / k, y / k);
	}
};

int n, x[maxn], r[maxn];
double d[maxn], abc[maxn];

double calc(double r1, double r2, double d) {
	double y = (r1 * r1 - r2 * r2 + d * d) / 2.0 / d;
	return 2.0 * sqrt(r1 * r1 - y * y);
}

bool check(double h) {
	for(int i = 0; i < n-1;) {
		if(r[i] * 2.0 < h + eps) {
			i++;
			continue;
		}
		double y = sqrt(r[i] * 1.0 * r[i] - h * h / 4.0);
		double lx = x[i] - y;
		double rx = lx + h;
		int j = i+1;
		while(j < n && d[j] + eps > h) j++;
		j--;
		if(j == i) {
			i = j+1;
			continue;
		}
		if(x[j] + eps > rx) return true;
		if(x[j] + r[j] < rx) {
			i = j+1;
			continue;
		}
		y = sqrt(r[j] * 1.0 * r[j] - h * h / 4.0);
		double RX = x[j] + y;
		if(RX + eps > rx) return true;
		i = j + 1;
	}
	return false;
}

bool solve() {
	scanf("%d", &n);
	if(!n) return false;

	for(int i = 0; i < n; i++) scanf("%d%d", x + i, r + i);

	for(int i = 1; i < n; i++) {
		d[i] = calc(r[i-1], r[i], x[i] - x[i-1]);
	}
	for(int i = 1; i < n; i++) {
		double t = sqrt(r[i] * 1.0 * r[i] - d[i] * d[i] / 4.0);
		abc[i] = x[i]-t;
	}

	double L = 0, R = 2 * maxn;

	for(int i = 0; i < n; i++) L = max(L, r[i] * sqrt(2.0));

	for(int iter = 0; iter < 100; iter++) {
		double mid = (L + R) / 2.0;
		bool cur = check(mid);
		if(cur) {
			L = mid;
		} else R = mid;
	}

	printf("%.9lf\n", L);

	return true;
}

int main () {

	#ifdef LOCAL
	freopen(file".in", "r", stdin);
	freopen(file".out", "w", stdout);
	#endif

	while(solve());

	#ifdef LOCAL
	cerr << (double)clock() * 1.0 / CLOCKS_PER_SEC << endl;
	#endif

	return 0;
}
















